/*******************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 *******************************************************************************

   Filename:
    $Workfile: $
   Last Modification:
    $Author: Dimitar $
    $Modtime:  $
    $Revision:  $

   Targets:


   Description:
    
   Resources

   Changes:

     Version    Date        Author   Description
     ---------------------------------------------------------------------------
          

*******************************************************************************/
#ifndef __VARAN_IOEXCHANGE_H_
#define __VARAN_IOEXCHANGE_H_

#include "TLR_Includes.h"
#include "VARANStack_Public.h"

#define VARAN_TRI_BUFF_ID_POS     14
#define VARAN_TRI_BUFF_INST_POS   12

#define VARAN_TRI_BUFF_MEM_AREA1  0
#define VARAN_TRI_BUFF_MEM_AREA2  1

/********************************************************
 *  Triple Buffer exchange structures
 ********************************************************/
typedef struct VARAN_CLIENT_INPUT_TRI_BUFFER_Ttag{
  TLR_UINT32 ulMemArea;
  TLR_UINT32 ulReserved;
  TLR_UINT32 ulLen;
  TLR_UINT8  abData[VARAN_CLIENT_BUFFER_SIZE];
}VARAN_CLIENT_INPUT_TRI_BUFFER_T;

typedef struct VARAN_CLIENT_OUTPUT_TRI_BUFFER_Ttag{
  TLR_UINT32 ulMemArea;
  TLR_UINT32 ulDataState;
  TLR_UINT32 ulLen;
  TLR_UINT8  abData[VARAN_CLIENT_BUFFER_SIZE];
}VARAN_CLIENT_OUTPUT_TRI_BUFFER_T;

typedef struct VARAN_RECV_TRIPLE_BUFFER_Ttag{
  TLR_BUFFERPOOL_T tTripleBufferPool; /* Triple buffer pool        */
  TLR_HANDLE       hTripleBuffer;     /* Handle for triple buffer  */
  TLR_UINT8        *pbCurTripleBuffer; /* Pointer to current buffer */

  VARAN_CLIENT_OUTPUT_TRI_BUFFER_T tTripleBufferA;
  VARAN_CLIENT_OUTPUT_TRI_BUFFER_T tTripleBufferB;
  VARAN_CLIENT_OUTPUT_TRI_BUFFER_T tTripleBufferC;

}VARAN_RECV_TRIPLE_BUFFER_T;

typedef struct VARAN_SEND_TRIPLE_BUFFER_Ttag{
  TLR_BUFFERPOOL_T tTripleBufferPool; /* Triple buffer pool        */
  TLR_HANDLE       hTripleBuffer;     /* Handle for triple buffer  */
  TLR_UINT8        *pbCurTripleBuffer; /* Pointer to current buffer */

  VARAN_CLIENT_INPUT_TRI_BUFFER_T tTripleBufferA;
  VARAN_CLIENT_INPUT_TRI_BUFFER_T tTripleBufferB;
  VARAN_CLIENT_INPUT_TRI_BUFFER_T tTripleBufferC;

}VARAN_SEND_TRIPLE_BUFFER_T;
      

#endif
